package gov.va.med.mhv.getcare.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="TREATMENT_FACILITIES")
public class TreatmentFacility implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name="TREATMENT_FACILITY_ID_SEQ")
	private Long treatmentFacilityId;

	@Column(name="ADDRESS_CITY")
	private String addressCity;

	@Column(name="ADDRESS_COUNTRY")
	private String addressCountry;

	@Column(name="ADDRESS_POSTAL_CODE")
	private String addressPostalCode;

	@Column(name="ADDRESS_PROVINCE")
	private String addressProvince;

	@Column(name="ADDRESS_STATE")
	private String addressState;

	@Column(name="ADDRESS_STREET_1")
	private String addressStreet1;

	@Column(name="ADDRESS_STREET_2")
	private String addressStreet2;

	private String comments;

	@Column(name="CONTACT_INFO_FAX")
	private String contactInfoFax;

	@Column(name="CONTACT_INFO_WORK_PHONE")
	private String contactInfoWorkPhone;

	@Column(name="CONTACT_INFO_WORK_PHONE_EXT")
	private String contactInfoWorkPhoneExt;

	@Column(name="FACILITY_NAME")
	private String facilityName;

	@Column(name="FACILITY_TYPE")
	private String facilityType;

	@Column(name="HOME_FACILITY")
	private Integer homeFacility;

	private Integer oplock;

	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userProfileId;

	public TreatmentFacility() {
	}

	public Long getTreatmentFacilityId() {
		return this.treatmentFacilityId;
	}

	public void setTreatmentFacilityId(Long treatmentFacilityId) {
		this.treatmentFacilityId = treatmentFacilityId;
	}

	public String getAddressCity() {
		return this.addressCity;
	}

	public void setAddressCity(String addressCity) {
		this.addressCity = addressCity;
	}

	public String getAddressCountry() {
		return this.addressCountry;
	}

	public void setAddressCountry(String addressCountry) {
		this.addressCountry = addressCountry;
	}

	public String getAddressPostalCode() {
		return this.addressPostalCode;
	}

	public void setAddressPostalCode(String addressPostalCode) {
		this.addressPostalCode = addressPostalCode;
	}

	public String getAddressProvince() {
		return this.addressProvince;
	}

	public void setAddressProvince(String addressProvince) {
		this.addressProvince = addressProvince;
	}

	public String getAddressState() {
		return this.addressState;
	}

	public void setAddressState(String addressState) {
		this.addressState = addressState;
	}

	public String getAddressStreet1() {
		return this.addressStreet1;
	}

	public void setAddressStreet1(String addressStreet1) {
		this.addressStreet1 = addressStreet1;
	}

	public String getAddressStreet2() {
		return this.addressStreet2;
	}

	public void setAddressStreet2(String addressStreet2) {
		this.addressStreet2 = addressStreet2;
	}

	public String getComments() {
		return this.comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getContactInfoFax() {
		return this.contactInfoFax;
	}

	public void setContactInfoFax(String contactInfoFax) {
		this.contactInfoFax = contactInfoFax;
	}

	public String getContactInfoWorkPhone() {
		return this.contactInfoWorkPhone;
	}

	public void setContactInfoWorkPhone(String contactInfoWorkPhone) {
		this.contactInfoWorkPhone = contactInfoWorkPhone;
	}

	public String getContactInfoWorkPhoneExt() {
		return this.contactInfoWorkPhoneExt;
	}

	public void setContactInfoWorkPhoneExt(String contactInfoWorkPhoneExt) {
		this.contactInfoWorkPhoneExt = contactInfoWorkPhoneExt;
	}

	public String getFacilityName() {
		return this.facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}

	public String getFacilityType() {
		return this.facilityType;
	}

	public void setFacilityType(String facilityType) {
		this.facilityType = facilityType;
	}

	

	public Integer getOplock() {
		return this.oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getUserProfileId() {
		return this.userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public Integer getHomeFacility() {
		return homeFacility;
	}

	public void setHomeFacility(Integer homeFacility) {
		this.homeFacility = homeFacility;
	}

	@Override
	public String toString() {
		return "TreatmentFacility [treatmentFacilityId=" + treatmentFacilityId + ", addressCity=" + addressCity
				+ ", addressCountry=" + addressCountry + ", addressPostalCode=" + addressPostalCode
				+ ", addressProvince=" + addressProvince + ", addressState=" + addressState + ", addressStreet1="
				+ addressStreet1 + ", addressStreet2=" + addressStreet2 + ", comments=" + comments
				+ ", contactInfoFax=" + contactInfoFax + ", contactInfoWorkPhone=" + contactInfoWorkPhone
				+ ", contactInfoWorkPhoneExt=" + contactInfoWorkPhoneExt + ", facilityName=" + facilityName
				+ ", facilityType=" + facilityType + ", homeFacility=" + homeFacility + ", oplock=" + oplock
				+ ", userProfileId=" + userProfileId + "]";
	}
	
}